unit AppServer;

interface

uses
  SysUtils, Classes, Forms, Controls, StdCtrls, ComCtrls, DB, DBClient,
  Buttons, ExtCtrls, uConexaoImpl, DataConexao, DMLista, Menus;

type
  TfmAppServer = class(TForm)
    Label1: TLabel;
    mmPkg: TMemo;
    sbServer: TStatusBar;
    btLoad: TSpeedButton;
    btUnload: TSpeedButton;
    tmServer: TTimer;
    bvServer: TBevel;
    SpeedButton1: TSpeedButton;
    procedure btLoadClick(Sender: TObject);
    procedure btUnloadClick(Sender: TObject);
    procedure tmServerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FConexao: TConexao;
    FLog: String;
    FNPac: integer;
    procedure SetLog(const Value: String);
    procedure SetNPac(const Value: integer);
    { Private declarations }
  public
    property Log: String read FLog write SetLog;
    property NPac: integer read FNPac write SetNPac;
    { Public declarations }
  end;

var
  fmAppServer: TfmAppServer;


implementation

uses SockApp, InvokeRegistry;

{$R *.dfm}

procedure TfmAppServer.btLoadClick(Sender: TObject);
begin
  try
    Screen.Cursor := crHourGlass;
    FConexao.CarregaPacotes;
  finally
    Screen.Cursor := crDefault;
  end;  
end;

procedure TfmAppServer.btUnloadClick(Sender: TObject);
begin
  try
    Screen.Cursor := crHourGlass;
    FConexao.DescarregaPacotes;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TfmAppServer.SetLog(const Value: String);
begin
  FLog := Value;
  mmPkg.Lines.Add(FLog);
end;

procedure TfmAppServer.tmServerTimer(Sender: TObject);
begin
  sbServer.Panels[1].Text := DateTimeToStr(Now);
end;

procedure TfmAppServer.FormCreate(Sender: TObject);
begin
  FConexao := TConexao.Create;
  Log :=  'Servidor Iniciado s: ' + TimeToStr(Time);
  Log := ('--------------------------------------------------------');
end;

procedure TfmAppServer.SetNPac(const Value: integer);
begin
  FNPac := Value;
  sbServer.Panels[0].Text := 'N de Pacotes carregados: ' + inttostr(FNPac);
end;

procedure TfmAppServer.SpeedButton1Click(Sender: TObject);
begin
  FConexao.Conexao := False;
  close;
end;

procedure TfmAppServer.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  FreeAndNil(FConexao);
end;

initialization
  TWebAppSockObjectFactory.Create('ActiveServer');
  dmDataConexao := TdmDataConexao.Create(Application);
  vDmLista := TList.Create;
finalization
  FreeAndNil(vDmLista);
end.
